/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.controllers.data.Line;

public class Lines {
    private static final Random random = new Random();
    private int lastLine = -1;
    public Map<Integer, Line> lines = new TreeMap<Integer, Line>();

    public Lines copy() {
        Lines newLines = new Lines();
        for (int i : this.lines.keySet()) {
            newLines.lines.put(i, this.lines.get(i));
        }
        return newLines;
    }

    public void correctLines() {
        TreeMap<Integer, Line> newLines = new TreeMap<Integer, Line>();
        int i = 0;
        boolean isChanged = false;
        for (int pos : this.lines.keySet()) {
            Line line;
            if (pos != i) {
                isChanged = true;
            }
            if ((line = this.lines.get(pos)).getText().isEmpty()) {
                isChanged = true;
                continue;
            }
            newLines.put(i, line);
            ++i;
        }
        if (isChanged) {
            this.lines = newLines;
        }
    }

    public Line getLine(boolean isRandom) {
        Line line;
        if (this.lines.isEmpty()) {
            return null;
        }
        if (isRandom) {
            int i = this.lastLine;
            if (this.lines.size() == 1) {
                i = 0;
            } else {
                while (i == this.lastLine) {
                    i = random.nextInt(this.lines.size());
                }
            }
            if (this.lines.containsKey(i)) {
                this.lastLine = i;
                return this.lines.get(i).copy();
            }
            for (Map.Entry<Integer, Line> e : this.lines.entrySet()) {
                if (--i >= 0) continue;
                this.lastLine = e.getKey();
                return e.getValue().copy();
            }
        }
        ++this.lastLine;
        while (true) {
            this.lastLine %= this.lines.size();
            line = this.lines.get(this.lastLine);
            if (line != null) break;
            ++this.lastLine;
        }
        return line.copy();
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public void readNBT(NBTTagCompound compound) {
        NBTTagList nbttaglist = compound.func_150295_c("Lines", 10);
        HashMap<Integer, Line> map = new HashMap<Integer, Line>();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            Line line = new Line();
            line.setText(nbttagcompound.func_74779_i("Line"));
            line.setSound(nbttagcompound.func_74779_i("Song"));
            map.put(nbttagcompound.func_74762_e("Slot"), line);
        }
        this.lines = map;
    }

    public void remove(int pos) {
        if (!this.lines.containsKey(pos)) {
            return;
        }
        this.lines.remove(pos);
        this.correctLines();
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (int slot : this.lines.keySet()) {
            Line line = this.lines.get(slot);
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74768_a("Slot", slot);
            tags.func_74778_a("Line", line.getText());
            tags.func_74778_a("Song", line.getSound());
            list.func_74742_a((NBTBase)tags);
        }
        nbt.func_74782_a("Lines", (NBTBase)list);
        return nbt;
    }
}

